<?php
/**
 * Plugin Name: Smart RTL Post
 * Plugin URI:  https://poetrypashto.com/smart-rtl-post/
 * Description: Change your post layout direction to right-to-left for languages like Pashto, Arabic, and Urdu — with just one click.
 * Version:     1.0.0
 * Author:      Luqman Safay
 * Author URI:  https://profiles.wordpress.org/luqmansafay/
 * Text Domain: smart-rtl-post
 * License:     GPLv2 or later
 * Requires at least: 5.0
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */




// Register Meta
function smart_rtl_register_meta() {
    register_post_meta('post', '_rtl_post_direction', array(
        'show_in_rest' => true,
        'type' => 'string',
        'single' => true,
        'sanitize_callback' => 'sanitize_text_field',
        'auth_callback' => function() {
            return current_user_can('edit_posts');
        }
    ));
}
add_action('init', 'smart_rtl_register_meta');

// Add Meta Box (Classic Editor)
function smart_rtl_add_meta_box() {
    add_meta_box('smart-rtl-box', __('Post Language Direction', 'smart-rtl-post'), 'smart_rtl_render_meta_box', 'post', 'side', 'default');
}
add_action('add_meta_boxes', 'smart_rtl_add_meta_box');

function smart_rtl_render_meta_box($post) {
    $value = get_post_meta($post->ID, '_rtl_post_direction', true);
    wp_nonce_field('smart_rtl_save_meta_box', 'smart_rtl_nonce');
    ?>
    <p>
        <label><input type="radio" name="smart_rtl_direction" value="ltr" <?php checked($value, 'ltr'); ?>> LTR (Default)</label><br>
        <label><input type="radio" name="smart_rtl_direction" value="rtl" <?php checked($value, 'rtl'); ?>> RTL (Pashto/Urdu)</label>
    </p>
    <?php
}

// Save Post Meta
function smart_rtl_save_post_meta($post_id) {
    if ( ! isset( $_POST['smart_rtl_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['smart_rtl_nonce'] ) ), 'smart_rtl_save_meta_box' ) ) {
    return;
}
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;
    if (isset($_POST['smart_rtl_direction'])) {
        update_post_meta($post_id, '_rtl_post_direction', sanitize_text_field($_POST['smart_rtl_direction']));
    }
}
add_action('save_post', 'smart_rtl_save_post_meta');

// Add class to body
function smart_rtl_add_body_class($classes) {
    if (is_singular('post')) {
        $dir = get_post_meta(get_the_ID(), '_rtl_post_direction', true);
        if ($dir === 'rtl') {
            $classes[] = 'rtl-post';
        }
    }
    return $classes;
}
add_filter('body_class', 'smart_rtl_add_body_class');

// Enqueue CSS
function smart_rtl_enqueue_css() {
    wp_enqueue_style('smart-rtl-style', plugin_dir_url(__FILE__) . 'css/rtl-style.css');
}
add_action('wp_enqueue_scripts', 'smart_rtl_enqueue_css');
